var weather = new Promise((resolve) => {
    setTimeout(() => {
        resolve({ temp: 29, conditions: 'Sunny with Clouds' });
    }, 2000);
});
debugger;
const tweets = new Promise((resolve, reject) => {
    setTimeout(() => {
        resolve(['I like cake', 'BBQ is good too!']);
    }, 500);
});

Promise
    .all([weather, tweets])
    .then(responses => {
        const [weatherInfo, tweetInfo] = responses;
        console.log(weatherInfo, tweetInfo);
    });

const postsPromise = fetch('http://wesbos.com/wp-json/wp/v2/posts');
const streetCarsPromise = fetch('http://data.ratp.fr/api/datasets/1.0/search/?q=paris');

Promise
    .all([postsPromise, streetCarsPromise])
    .then(responses => {
        return Promise.all(responses.map(res => res.json()));
    })
    .then(responses => {
        console.log(responses);
    });